//===========================================================================================\\

//    -2203 ""   "Operation Flashpoint"
//  2.7

//====================================== Shadow, 2015 =======================================\\



class CfgPatches
{
	class RAF_2203 {units[] = {"RAF_2203","RAF_22031","RAF_2203_militia_and_headquarter","TAMRO_RAF_reanimation","RAF_2203_01","RAF_22031_01","RAF_2203_01_militia_and_headquarter","RAF_2914_01_reanimation","RAF_33113_01"}; weapons[] = {}; requiredVersion = 1.91;};};



class CfgModels
{
 	class Default {};
	class Vehicle: Default {};
	class Car: Vehicle {};

 	class RAF_2203: Car {sectionsInherit = "Car"; sections[] = {"color","wheel_covers","wheel_onlays","early_emblem","early_sidelights_mask","later_turn_lights","extra","civilian_plates_mask","military_plates","taxi","Aeroflot","television","GSFG","brzdove svetlo","zadni svetlo","L svetlo","P svetlo","clan","clan_sign"};};
	class RAF_22031: Car {sectionsInherit = "Car"; sections[] = {"wheel_covers","wheel_onlays","early_emblem","early_sidelights_mask","later_turn_lights","extra","SMP","PMP","GAI","first_half_of_movement_of_flasher","second_half_of_movement_of_flasher","brzdove svetlo","zadni svetlo","L svetlo","P svetlo","clan","clan_sign"};};
	class RAF_2203_militia_and_headquarter: Car {sectionsInherit = "Car"; sections[] = {"color","wheel_covers","wheel_onlays","early_emblem","early_sidelights_mask","later_turn_lights","extra","GAI","militia","lab","lab_equipment","headquarter","blazon","seats","compartment","first_half_of_movement_of_flasher","second_half_of_movement_of_flasher","brzdove svetlo","zadni svetlo","L svetlo","P svetlo","clan","clan_sign"};};
	class TAMRO_RAF_reanimation: Car {sectionsInherit = "Car"; sections[] = {"wheel_covers","wheel_onlays","extra","SMP","GAI","first_half_of_movement_of_flasher","second_half_of_movement_of_flasher","brzdove svetlo","zadni svetlo","L svetlo","P svetlo","clan","clan_sign"};};
	class RAF_2203_01: Car {sectionsInherit = "Car"; sections[] = {"color","wheel_covers","wheel_onlays","extra","taxi","Aeroflot","television","brzdove svetlo","zadni svetlo","L svetlo","P svetlo","clan","clan_sign"};};
	class RAF_22031_01: Car {sectionsInherit = "Car"; sections[] = {"wheel_covers","wheel_onlays","extra","SMP","PMP","GAI","first_half_of_movement_of_flasher","second_half_of_movement_of_flasher","brzdove svetlo","zadni svetlo","L svetlo","P svetlo","clan","clan_sign"};};
	class RAF_2203_01_militia_and_headquarter: Car {sectionsInherit = "Car"; sections[] = {"color","wheel_covers","wheel_onlays","extra","GAI","militia","lab","lab_equipment","headquarter","seats","compartment","first_half_of_movement_of_flasher","second_half_of_movement_of_flasher","brzdove svetlo","zadni svetlo","L svetlo","P svetlo","left_extra_headlamp","right_extra_headlamp","clan","clan_sign"};};
	class RAF_2914_01_reanimation: Car {sectionsInherit = "Car"; sections[] = {"wheel_covers","wheel_onlays","extra","brzdove svetlo","zadni svetlo","L svetlo","P svetlo","clan","clan_sign"};};
	class RAF_33113_01: Car {sectionsInherit = "Car"; sections[] = {"wheel_covers","wheel_onlays","extra","awning","brzdove svetlo","zadni svetlo","L svetlo","P svetlo","clan","clan_sign"};};
};



class CfgTextureToMaterial
{
	class RAF_2203_general {textures[] = {"RAF-2203\Textures\1022az.paa","RAF-2203\Textures\3746sa.paa","RAF-2203\Textures\Aeroflot.paa","RAF-2203\Textures\Amb_GAI.paa","RAF-2203\Textures\Amb_gl.paa","RAF-2203\Textures\Amb_gl2.paa","RAF-2203\Textures\Amb_gl4.paa","RAF-2203\Textures\Glass.paa","RAF-2203\Textures\GSFG.paa","RAF-2203\Textures\Head.paa","RAF-2203\Textures\Lab.paa","RAF-2203\Textures\Lab2.paa","RAF-2203\Textures\Latvija.paa","RAF-2203\Textures\Mil.paa","RAF-2203\Textures\Mil2.paa","RAF-2203\Textures\Plastic.paa","RAF-2203\Textures\PMP.paa","RAF-2203\Textures\RAF_2914.paa","RAF-2203\Textures\RAF_amb.paa","RAF-2203\Textures\RAF_azure.paa","RAF-2203\Textures\RAF_b_gr.paa","RAF-2203\Textures\RAF_blue.paa","RAF-2203\Textures\RAF_d_gr.paa","RAF-2203\Textures\RAF_fire.paa","RAF-2203\Textures\RAF_GSFG.paa","RAF-2203\Textures\RAF_mil.paa","RAF-2203\Textures\RAF_mil_r.paa","RAF-2203\Textures\RAF_white_blue.paa","RAF-2203\Textures\RAF_red.paa","RAF-2203\Textures\RAF_TAMRO.paa","RAF-2203\Textures\RAF_white.paa","RAF-2203\Textures\RAF_yel.paa","RAF-2203\Textures\Reanim.paa","RAF-2203\Textures\Seat.paa","RAF-2203\Textures\Seat2.paa","RAF-2203\Textures\Seat3.paa","RAF-2203\Textures\Seat4.paa","RAF-2203\Textures\SMP.paa","RAF-2203\Textures\TAMRO6.paa","RAF-2203\Textures\Taxi.paa","RAF-2203\Textures\TV.paa","RAF-2203\Textures\Wood1.paa","RAF-2203\Textures\Wood2.paa"}; material = #RAF_2203_general;};
	class RAF_2203_metal {textures[] = {"RAF-2203\Textures\Metal.paa"}; material = #RAF_2203_metal;};
	class RAF_2203_chrome {textures[] = {"RAF-2203\Textures\Cover.paa"}; material = #RAF_2203_chrome;};
};



class CfgMaterials
{
	class RAF_2203_general {ambient[] = {1,1,1,1}; diffuse[] = {1,1,1,1}; forcedDiffuse[] = {0,0,0,0}; specular[] = {0.1,0.1,0.1,1}; specularPower = 50; emmisive[] = {0,0,0,0};};
	class RAF_2203_metal {ambient[] = {1,1,1,1}; diffuse[] = {1,1,1,1}; forcedDiffuse[] = {0,0,0,0}; specular[] = {0.3,0.3,0.3,1}; specularPower = 50; emmisive[] = {0,0,0,0};};
	class RAF_2203_chrome {ambient[] = {1,1,1,1}; diffuse[] = {1,1,1,1}; forcedDiffuse[] = {0,0,0,0}; specular[] = {0.7,0.7,0.7,1}; specularPower = 50; emmisive[] = {0,0,0,0};};
};



class CfgVehicleActions
{
	RAF_2203_driver = "RAF_2203_driver";
};



class CfgMovesMC
{
	class Default {};
	class DefaultDie: Default {};
	class DeadState: Default {};
	
	class States
		{
		class Driver: Default {};

		class RAF_2203_driver: Driver {file = "\RAF-2203\Animations\RAF_2203_driver.rtm"; speed = 10000000000.0; looped = 1; variantsAI[] = {"RAF_2203_driver_dinamic",0.7,"RAF_2203_driver"}; interpolateWith[] = {"RAF_2203_driver_dinamic",0.5}; equivalentTo = "RAF_2203_driver"; interpolationSpeed = 1; connectTo[] = {"RAF_2203_driver_dying",1};};
		class RAF_2203_driver_dinamic: RAF_2203_driver {file = "\RAF-2203\Animations\RAF_2203_driver_dinamic.rtm"; speed=-4; looped = 1;};
		class RAF_2203_driver_dying: DefaultDie {actions="NoActions"; file = "\RAF-2203\Animations\RAF_2203_driver_dying.rtm"; speed = -1; looped = 0; soundEnabled = 0; connectFrom[]={"RAF_2203_driver",1};};
		class RAF_2203_driver_dead: RAF_2203_driver_dying {actions = "DeadActions"; file = "\RAF-2203\Animations\RAF_2203_driver_dead.rtm"; speed = 10000000000.0; terminal = 1; connectFrom[] = {"RAF_2203_driver_dying",1}; connectTo[] = {"DeadState",1};};
		};
};



class CfgSounds
{
	class RAF_2203_motor_start {sound[] = {"\RAF-2203\Sounds\Motor_start.ogg",0.01,1.0}; name = "RAF_2203_motor_start"; titles[] = {};};
	class RAF_2203_motor_start_failure {sound[] = {"\RAF-2203\Sounds\Motor_start_failure.ogg",0.01,1.0}; name = "RAF_2203_motor_start_failure"; titles[] = {};};
	class RAF_2203_motor_off {sound[] = {"\RAF-2203\Sounds\Motor_off.ogg",0.01,1.0}; name = "RAF_2203_motor_off"; titles[] = {};};
	class RAF_2203_motor_idle {sound[] = {"\RAF-2203\Sounds\Motor_idle.ogg",0.01,1.0}; name = "RAF_2203_motor_idle"; titles[] = {};};
	class RAF_2203_motor_idle_up {sound[] = {"\RAF-2203\Sounds\Motor_idle_up.ogg",0.01,1.0}; name = "RAF_2203_motor_idle_up"; titles[] = {};};
	class RAF_2203_motor_idle_down {sound[] = {"\RAF-2203\Sounds\Motor_idle_down.ogg",0.01,1.0}; name = "RAF_2203_motor_idle_down"; titles[] = {};};
	class RAF_2203_handbreak_on {sound[] = {"\RAF-2203\Sounds\Handbrake_on.ogg",0.001,1.0}; name = "RAF_2203_handbreak_on"; titles[] = {};};
	class RAF_2203_handbreak_off {sound[] = {"\RAF-2203\Sounds\Handbrake_off.ogg",0.003,1.0}; name = "RAF_2203_handbreak_off"; titles[] = {};};
	class RAF_2203_braking {sound[] = {"\RAF-2203\Sounds\Braking.ogg",0.02,1.0}; name = "RAF_2203_braking"; titles[] = {};};
	class RAF_2203_turn_lights_relay_on {sound[] = {"\RAF-2203\Sounds\Turn_lights_relay_on.ogg",0.001,1.0}; name = "RAF_2203_turn_lights_on"; titles[] = {};};
	class RAF_2203_turn_lights_relay_off {sound[] = {"\RAF-2203\Sounds\Turn_lights_relay_off.ogg",0.001,1.0}; name = "RAF_2203_turn_lights_off"; titles[] = {};};
	class RAF_2203_ambulance_siren {sound[] = {"\RAF-2203\Sounds\Ambulance_siren.ogg",0.02,1.0}; name = "RAF_2203_ambulance_siren"; titles[] = {};};
	class RAF_2203_ambulance_siren_off {sound[] = {"\RAF-2203\Sounds\Ambulance_siren_off.ogg",0.02,1.0}; name = "RAF_2203_ambulance_siren_off"; titles[] = {};};
	class RAF_2203_Tesla_siren_on {sound[] = {"\RAF-2203\Sounds\Tesla_siren_on.ogg",0.02,1.0}; name = "RAF_2203_Tesla_siren_on"; titles[] = {};};
	class RAF_2203_Tesla_siren_on_2 {sound[] = {"\RAF-2203\Sounds\Tesla_siren_on_2.ogg",0.02,1.0}; name = "RAF_2203_Tesla_siren_on_2"; titles[] = {};};
	class RAF_2203_Tesla_siren {sound[] = {"\RAF-2203\Sounds\Tesla_siren.ogg",0.02,1.0}; name = "RAF_2203_Tesla_siren"; titles[] = {};};
	class RAF_2203_Tesla_siren_off {sound[] = {"\RAF-2203\Sounds\Tesla_siren_off.ogg",0.001,1.0}; name = "RAF_2203_Tesla_siren_off"; titles[] = {};};
	class TAMRO_RAF_siren {sound[] = {"\RAF-2203\Sounds\TAMRO_RAF_siren.ogg",0.03,1.0}; name = "TAMRO_RAF_siren"; titles[] = {};};
};



class CfgWeapons
{
	class Default {};
	class CarHorn: Default {};

	class RAF_2203_klaxon: Carhorn {drySound[] = {"\RAF-2203\Sounds\Klaxon.ogg",0.01,1.0};};

	class RAF_2203_1977_1978: Default {showEmpty = false;};
	class RAF_2203_wheel_covers: Default {showEmpty = false;};
	class RAF_2203_wheel_onlays: Default {showEmpty = false;};
	class RAF_2203_taxi: Default {showEmpty = false;};
	class RAF_2203_Aeroflot: Default {showEmpty = false;};
	class RAF_2203_television: Default {showEmpty = false;};
	class RAF_2203_ambulance_GAI: Default {showEmpty = false;};
	class RAF_2203_militia_red: Default {showEmpty = false;};
	class RAF_2203_militia_blue: Default {showEmpty = false;};
	class RAF_2203_militia_green: Default {showEmpty = false;};
	class RAF_2203_militia_white: Default {showEmpty = false;};
	class RAF_2203_militia_GAI: Default {showEmpty = false;};
	class RAF_2203_militia_lab: Default {showEmpty = false;};
	class RAF_2203_headquarter_inscriptions: Default {showEmpty = false;};
	class TAMRO_RAF_inscriptions: Default {showEmpty = false;};
	class RAF_33113_awning: Default {showEmpty = false;};

	class RAF_2203_GSFG_3746sa: Default {showEmpty = false;};
	class RAF_2203_GSFG_1022az: Default {showEmpty = false;};
	class RAF_2203_extra: Default {showEmpty = false;};
	class RAF_2203_extra2: Default {showEmpty = false;};
	class RAF_2203_extra3: Default {showEmpty = false;};
	class RAF_2203_extra4: Default {showEmpty = false;};
	class RAF_2203_extra5: Default {showEmpty = false;};
	class RAF_2203_lack_of_fuel: Default {showEmpty = false;};
};



class CfgVehicles
{
	class All {};
	class AllVehicles: All {};
	class Land: AllVehicles {};
	class LandVehicle: Land {};
	class Car: LandVehicle {};
	class SkodaHelper: Car {};
	class SkodaBase: SkodaHelper {};

	class RAF_2203_blue: SkodaBase
		{
		scope = 2;
		model = "\RAF-2203\Models\RAF_2203.p3d";
		hiddenSelections[] = {"color","wheel_covers","wheel_onlays","early_emblem","early_sidelights_mask","later_turn_lights","extra","civilian_plates_mask","military_plates","taxi","Aeroflot","television","GSFG"};
		vehicleClass = "$STR_RAF_2203_class";
		displayName = "$STR_RAF_2203_blue";
		icon = "\RAF-2203\Textures\Icons\RAF_2203.paa";
		picture = "\RAF-2203\Textures\Pictures\RAF_2203_blue.paa";
		mapSize = 6.75;
		crew = "Civilian9";
		driverAction = "ManActRAF_2203_driver";
		codriverAction = "ManActSkodaCoDriverBack";
		weapons[] = {"RAF_2203_klaxon","RAF_2203_wheel_covers"};
		transportSoldier = 11;
		castDriverShadow = true;
  		castCargoShadow = true;
		hideWeaponsDriver = true;
		hideWeaponsCargo = true;
		cargoAction[] = {ManActSkodaCoDriverBack, ManActSkodaCoDriverBack, ManActSkodaCoDriverBack, ManActBusCargo, ManActSkodaCoDriverBack, ManActSkodaCoDriverBack, ManActBusCargo, ManActSkodaCoDriverBack, ManActSkodaCoDriverBack, ManActBusCargo, ManActSkodaCoDriverBack};
		getInRadius = 1.5;
		maxSpeed = 90;
		turnCoef = 2.7;
		terrainCoef = 9;
		damperSize = 0.2;
		damperForce = 50;
		brakeDistance = 0.001;
		fuelCapacity = 400;
		transportMaxMagazines = 100;
		transportMaxWeapons = 50;
		soundEngine[] = {"\RAF-2203\Sounds\Motor.ogg",0.1,1.0};
		soundGetIn[] = {"\RAF-2203\Sounds\Doors.ogg",0.01,1.0};
		soundGetOut[] = {"\RAF-2203\Sounds\Doors.ogg",0.01,1.0};
		soundEnviron[]={\RAF-2203\Sounds\Creak.ogg,0.015,1.0};
		soundCrash[] = {"\RAF-2203\Sounds\Crash.ogg",0.02,1.0};
		soundLandCrash[] = {"\RAF-2203\Sounds\Crash.ogg",0.02,1.0};
		soundGear[] = {"",0,0};
		soundDammage[] = {"",0,0};
		soundServo[] = {"",0,0};
		accuracy = 0.5;
		destrType = "DestructMan";
		armorWheels = 0.1;
		armorGlass = 0.15;
		dammageHalf[] = {"\RAF-2203\Textures\Glass.paa","\RAF-2203\Textures\Glass_1.paa"};
		dammageFull[] = {"\RAF-2203\Textures\Glass.paa","\RAF-2203\Textures\Glass_2.paa"};
		
		class IndicatorSpeed {selection = "ukaz_rychlo"; axis = "osa_rychlo"; angle = -197; min = 0; max = 48.5;};

		class Reflectors
 			{
   			class Left {color[] = {1.0,0.9,0.6,0.35}; ambient[]={1.0,0.9,0.6,0.35}; position = "L svetlo"; direction = "konec L svetla"; hitpoint = "L svetlo"; selection = "L svetlo"; size = 0.5; brightness = 0.25;};
   			class Right {color[] = {1.0,0.9,0.6,0.35}; ambient[]={1.0,0.9,0.6,0.35}; position = "P svetlo"; direction = "konec P svetla"; hitpoint = "P svetlo"; selection = "P svetlo"; size = 0.5; brightness = 0.25;};
			};

		class Animations
			{
			class Dynamic_suspension {type = "rotation"; animperiod = 0.5; selection = "dynamic_suspension"; axis = "dynamic_suspension_axis"; angle0 = -0.1; angle1 = 0.1;};
			class Tilts {type = "rotation"; animperiod = 5; selection = "tilts"; axis = "tilts_axis"; angle0 = 1; angle1 = -1;};
			class Fuel_gauge {type = "rotation"; animPeriod = 3; selection = "fuel_gauge"; axis = "fuel_gauge_axis"; angle0 = 0; angle1 = -1.15;};
			class Inside_sounds_switcher {type = "rotation"; animPeriod = 0.01; selection = "inside_sounds_switcher"; axis = "switchers_axis"; angle0 = 0; angle1 = 3.141592;};
			class Turn_lights_switcher {type = "rotation"; animPeriod = 0.25; selection = "turn_lights_switcher"; axis = "turn_lights_switcher_axis"; angle0 = -0.5; angle1 = 0.5;};
			class Emergency_lights_switcher {type = "rotation"; animPeriod = 0.1; selection = "emergency_lights_switcher"; axis = "emergency_lights_switcher_axis"; angle0 = 0; angle1 = -0.003;};
			class Front_left_turn_light {type = "rotation"; animPeriod = 0.01; selection = "front_left_turn_light"; axis = "front_left_turn_light_axis"; angle0 = 3.141592; angle1 = 0;};
			class Front_right_turn_light {type = "rotation"; animPeriod = 0.01; selection = "front_right_turn_light"; axis = "front_right_turn_light_axis"; angle0 = 3.141592; angle1 = 0;};
			class GAZ_24_front_left_turn_light {type = "rotation"; animPeriod = 0.01; selection = "GAZ_24_front_left_turn_light"; axis = "front_left_turn_light_axis"; angle0 = 3.141592; angle1 = 0;};
			class GAZ_24_front_right_turn_light {type = "rotation"; animPeriod = 0.01; selection = "GAZ_24_front_right_turn_light"; axis = "front_right_turn_light_axis"; angle0 = 3.141592; angle1 = 0;};
			class Side_left_turn_light {type = "rotation"; animPeriod = 0.01; selection = "side_left_turn_light"; axis = "side_left_turn_light_axis"; angle0 = -3.141592; angle1 = 0;};
			class Side_right_turn_light {type = "rotation"; animPeriod = 0.01; selection = "side_right_turn_light"; axis = "side_right_turn_light_axis"; angle0 = 3.141592; angle1 = 0;};
			class Back_left_turn_light {type = "rotation"; animPeriod = 0.01; selection = "back_left_turn_light"; axis = "back_lights_axis"; angle0 = 3.141592; angle1 = 0;};
			class Back_right_turn_light {type = "rotation"; animPeriod = 0.01; selection = "back_right_turn_light"; axis = "back_lights_axis"; angle0 = 3.141592; angle1 = 0;};
			class Turn_lights_indicator {type = "rotation"; animPeriod = 0.01; selection = "turn_lights_indicator"; axis = "turn_lights_indicator_axis"; angle0 = 3.141592; angle1 = 0;};
			class Emergency_lights_indicator {type = "rotation"; animPeriod = 0.01; selection = "emergency_lights_indicator"; axis = "emergency_lights_indicator_axis"; angle0 = -3.141592; angle1 = 0;};
			class Wipers_switcher {type = "rotation"; animPeriod = 0.15; selection = "wipers_switcher"; axis = "wipers_switcher_axis"; angle0 = 0; angle1 = 0.5;};
			class Wiper1 {type = "rotation"; animPeriod = 1.5; selection = "wiper1"; axis = "wiper1_axis"; angle0 = 0; angle1 = -1.7;};
		  	class Wiper2 {type = "rotation"; animPeriod = 1.5; selection = "wiper2"; axis = "wiper2_axis"; angle0 = 0; angle1 = -2;};
			class Handbreak_switcher {type = "rotation"; animPeriod = 0.3; selection = "handbreak_switcher"; axis = "handbreak_switcher_axis"; angle0 = 0; angle1 = 0.7;};
			class Handbreak_indicator {type = "rotation"; animPeriod = 0.01; selection = "handbreak_indicator"; axis = "handbreak_indicator_axis"; angle0 = 3.141592; angle1 = 0;};
			class Reversing_lights {type = "rotation"; animPeriod = 0.01; selection = "reversing_lights"; axis = "back_lights_axis"; angle0 = 3.141592; angle1 = 0;};
			class Lights_breaking {type = "rotation"; animPeriod = 0.01; selection = "lights_breaking"; axis = "lights_breaking_axis"; angle0 = 0; angle1 = 3.141592;};
			};

		class UserActions
			{		
			class Left_turn_lights_on {displayName = "$STR_RAF_2203_left_turn_lights_on"; position = "driver"; radius = 0.5; condition = "(alive this) and (this animationPhase ""Turn_lights_switcher"" == 0.5) and (this animationPhase ""Emergency_lights_switcher"" == 0)"; statement = "this animate [""Turn_lights_switcher"",0]";};
			class Right_turn_lights_on {displayName = "$STR_RAF_2203_right_turn_lights_on"; position = "driver"; radius = 0.5; condition = "(alive this) and (this animationPhase ""Turn_lights_switcher"" == 0.5) and (this animationPhase ""Emergency_lights_switcher"" == 0)"; statement = "this animate [""Turn_lights_switcher"",1]";};
			class Turn_lights_off {displayName = "$STR_RAF_2203_turn_lights_off"; position = "driver"; radius = 0.5; condition = "(alive this) and (this animationPhase ""Turn_lights_switcher"" != 0.5)"; statement = "this animate [""Turn_lights_switcher"",0.5]";};
			class Emergency_lights_on {displayName = "$STR_RAF_2203_emergency_lights_on"; position = "driver"; radius = 0.5; condition = "(alive this) and (this animationPhase ""Emergency_lights_switcher"" == 0) and (this animationPhase ""Turn_lights_switcher"" == 0.5)"; statement = "this animate [""Emergency_lights_switcher"",1]";};
			class Emergency_lights_off {displayName = "$STR_RAF_2203_emergency_lights_off"; position = "driver"; radius = 0.5; condition = "(alive this) and (this animationPhase ""Emergency_lights_switcher"" == 1)"; statement = "this animate [""Emergency_lights_switcher"",0]";};
			class Wipers_on {displayName = "$STR_RAF_2203_wipers_on"; position = "driver"; radius = 0.5; condition = "(alive this) and (this animationPhase ""Wipers_switcher"" == 0)"; statement = "this animate [""Wipers_switcher"",1]";};
			class Wipers_off {displayName = "$STR_RAF_2203_wipers_off"; position = "driver"; radius = 0.5; condition = "(alive this) and (this animationPhase ""Wipers_switcher"" == 1)"; statement = "this animate [""Wipers_switcher"",0]";};
			class Handbreak_on {displayName = "$STR_RAF_2203_handbreak_on"; position = "driver"; radius = 0.5; condition = "(alive this) and (this animationPhase ""Handbreak_switcher"" == 0)"; statement = "this animate [""Handbreak_switcher"",1]";};
			class Handbreak_off {displayName = "$STR_RAF_2203_handbreak_off"; position = "driver"; radius = 0.5; condition = "(alive this) and (this animationPhase ""Handbreak_switcher"" == 1)"; statement = "this animate [""Handbreak_switcher"",0]";};
			};

		class EventHandlers
			{
			Init = "[_this select 0] exec ""\RAF-2203\Scripts\Init.sqs"" ";
			Engine = "[_this select 0] exec ""\RAF-2203\Scripts\Engine.sqs"" ";
			};
		};

	class RAF_2203_white_blue: RAF_2203_blue
		{
		displayName = "$STR_RAF_2203_white_blue";
		picture = "\RAF-2203\Textures\Pictures\RAF_2203_white_blue.paa";
		};

	class RAF_2203_yellow: RAF_2203_blue
		{
		displayName = "$STR_RAF_2203_yellow";
		picture = "\RAF-2203\Textures\Pictures\RAF_2203_yellow.paa";
		};

	class RAF_2203_bright_green: RAF_2203_blue
		{
		displayName = "$STR_RAF_2203_bright_green";
		picture = "\RAF-2203\Textures\Pictures\RAF_2203_bright_green.paa";
		};

	class RAF_2203_dark_green: RAF_2203_blue
		{
		displayName = "$STR_RAF_2203_dark_green";
		picture = "\RAF-2203\Textures\Pictures\RAF_2203_dark_green.paa";
		};

	class RAF_2203_red: RAF_2203_blue
		{
		displayName = "$STR_RAF_2203_red";
		picture = "\RAF-2203\Textures\Pictures\RAF_2203_red.paa";
		};

	class RAF_2203_azure: RAF_2203_blue
		{
		displayName = "$STR_RAF_2203_azure";
		picture = "\RAF-2203\Textures\Pictures\RAF_2203_azure.paa";
		};

	class RAF_2203_GSFG: RAF_2203_blue
		{
		side = TEast;
		displayName = "$STR_RAF_2203_GSFG";
		picture = "\RAF-2203\Textures\Pictures\RAF_2203_GSFG.paa";
		crew = "SoldierEB";
		};

	class RAF_22031: RAF_2203_blue
		{
		model = "\RAF-2203\Models\RAF_22031.p3d";
		hiddenSelections[] = {"nothing","wheel_covers","wheel_onlays","early_emblem","early_sidelights_mask","later_turn_lights","extra","nothing","nothing","nothing","nothing","nothing","nothing","SMP","PMP","GAI","nothing","nothing","nothing","nothing","nothing","nothing","nothing","nothing","first_half_of_movement_of_flasher","second_half_of_movement_of_flasher"};
		displayName = "$STR_RAF_22031";
		icon = "\RAF-2203\Textures\Icons\RAF_22031.paa";
		picture = "\RAF-2203\Textures\Pictures\RAF_22031.paa";
		transportSoldier = 5;
		cargoAction[] = {ManActSkodaCoDriverBack, ManActBusCargo, ManActSkodaCoDriverBack, ManActBusCargo, ManActM113Injured};
		maxSpeed = 85;
		dammageHalf[] = {"\RAF-2203\Textures\Glass.paa","\RAF-2203\Textures\Glass_1.paa","\RAF-2203\Textures\Amb_gl.paa","\RAF-2203\Textures\Amb_gl1.paa","\RAF-2203\Textures\Amb_gl2.paa","\RAF-2203\Textures\Amb_gl3.paa","\RAF-2203\Textures\Amb_gl4.paa","\RAF-2203\Textures\Amb_gl5.paa"};
		dammageFull[] = {"\RAF-2203\Textures\Glass.paa","\RAF-2203\Textures\Glass_2.paa","\RAF-2203\Textures\Amb_gl.paa","\Data\Jeep_kab_sklo2c.paa","\RAF-2203\Textures\Amb_gl2.paa","\RAF-2203\Textures\Amb_gl3.paa","\RAF-2203\Textures\Amb_gl4.paa","\RAF-2203\Textures\Amb_gl5.paa"};
		nameSound = "ambulance";
		attendant = 1;

		class Animations
			{
			class Dynamic_suspension {type = "rotation"; animperiod = 0.5; selection = "dynamic_suspension"; axis = "dynamic_suspension_axis"; angle0 = -0.1; angle1 = 0.1;};
			class Tilts {type = "rotation"; animperiod = 5; selection = "tilts"; axis = "tilts_axis"; angle0 = 1; angle1 = -1;};
			class Fuel_gauge {type = "rotation"; animPeriod = 1; selection = "fuel_gauge"; axis = "fuel_gauge_axis"; angle0 = 0; angle1 = -1.15;};
			class Inside_sounds_switcher {type = "rotation"; animPeriod = 0.01; selection = "inside_sounds_switcher"; axis = "switchers_axis"; angle0 = 0; angle1 = 3.141592;};
			class Turn_lights_switcher {type = "rotation"; animPeriod = 0.25; selection = "turn_lights_switcher"; axis = "turn_lights_switcher_axis"; angle0 = -0.5; angle1 = 0.5;};
			class Emergency_lights_switcher {type = "rotation"; animPeriod = 0.1; selection = "emergency_lights_switcher"; axis = "emergency_lights_switcher_axis"; angle0 = 0; angle1 = -0.003;};
			class Front_left_turn_light {type = "rotation"; animPeriod = 0.01; selection = "front_left_turn_light"; axis = "front_left_turn_light_axis"; angle0 = 3.141592; angle1 = 0;};
			class Front_right_turn_light {type = "rotation"; animPeriod = 0.01; selection = "front_right_turn_light"; axis = "front_right_turn_light_axis"; angle0 = 3.141592; angle1 = 0;};
			class GAZ_24_front_left_turn_light {type = "rotation"; animPeriod = 0.01; selection = "GAZ_24_front_left_turn_light"; axis = "front_left_turn_light_axis"; angle0 = 3.141592; angle1 = 0;};
			class GAZ_24_front_right_turn_light {type = "rotation"; animPeriod = 0.01; selection = "GAZ_24_front_right_turn_light"; axis = "front_right_turn_light_axis"; angle0 = 3.141592; angle1 = 0;};
			class Side_left_turn_light {type = "rotation"; animPeriod = 0.01; selection = "side_left_turn_light"; axis = "side_left_turn_light_axis"; angle0 = -3.141592; angle1 = 0;};
			class Side_right_turn_light {type = "rotation"; animPeriod = 0.01; selection = "side_right_turn_light"; axis = "side_right_turn_light_axis"; angle0 = 3.141592; angle1 = 0;};
			class Back_left_turn_light {type = "rotation"; animPeriod = 0.01; selection = "back_left_turn_light"; axis = "back_lights_axis"; angle0 = 3.141592; angle1 = 0;};
			class Back_right_turn_light {type = "rotation"; animPeriod = 0.01; selection = "back_right_turn_light"; axis = "back_lights_axis"; angle0 = 3.141592; angle1 = 0;};
			class Turn_lights_indicator {type = "rotation"; animPeriod = 0.01; selection = "turn_lights_indicator"; axis = "turn_lights_indicator_axis"; angle0 = 3.141592; angle1 = 0;};
			class Emergency_lights_indicator {type = "rotation"; animPeriod = 0.01; selection = "emergency_lights_indicator"; axis = "emergency_lights_indicator_axis"; angle0 = -3.141592; angle1 = 0;};
			class Wipers_switcher {type = "rotation"; animPeriod = 0.15; selection = "wipers_switcher"; axis = "wipers_switcher_axis"; angle0 = 0; angle1 = 0.5;};
			class Wiper1 {type = "rotation"; animPeriod = 1.5; selection = "wiper1"; axis = "wiper1_axis"; angle0 = 0; angle1 = -1.8;};
		  	class Wiper2 {type = "rotation"; animPeriod = 1.5; selection = "wiper2"; axis = "wiper2_axis"; angle0 = 0; angle1 = -1.8;};
			class Handbreak_switcher {type = "rotation"; animPeriod = 0.3; selection = "handbreak_switcher"; axis = "handbreak_switcher_axis"; angle0 = 0; angle1 = 0.7;};
			class Handbreak_indicator {type = "rotation"; animPeriod = 0.01; selection = "handbreak_indicator"; axis = "handbreak_indicator_axis"; angle0 = 3.141592; angle1 = 0;};
			class Reversing_lights {type = "rotation"; animPeriod = 0.01; selection = "reversing_lights"; axis = "back_lights_axis"; angle0 = 3.141592; angle1 = 0;};
			class Flasher_switcher {type = "rotation"; animPeriod = 0.1; selection = "flasher_switcher"; axis = "switchers_axis"; angle0 = 0; angle1 = 3.141592;};
			class First_half_of_movement_of_flasher {type = "rotation"; animPeriod = 0.2; selection = "first_half_of_movement_of_flasher"; axis = "flasher_axis"; angle0 = 0; angle1 = -3.141592;};
			class Second_half_of_movement_of_flasher {type = "rotation"; animPeriod = 0.2; selection = "second_half_of_movement_of_flasher"; axis = "flasher_axis"; angle0 = 0; angle1 = -3.141592;};
			class Flasher_indicator {type = "rotation"; animPeriod = 0.01; selection = "flasher_indicator"; axis = "flasher_indicator_axis"; angle0 = 3.141592; angle1 = 0;};
			class Siren_switcher {type = "rotation"; animPeriod = 0.1; selection = "siren_switcher"; axis = "switchers_axis"; angle0 = 0; angle1 = 3.141592;};
			class Lights_breaking {type = "rotation"; animPeriod = 0.01; selection = "lights_breaking"; axis = "lights_breaking_axis"; angle0 = 0; angle1 = 3.141592;};
			};

		class UserActions
			{		
			class Left_turn_lights_on {displayName = "$STR_RAF_2203_left_turn_lights_on"; position = "driver"; radius = 0.5; condition = "(alive this) and (this animationPhase ""Turn_lights_switcher"" == 0.5) and (this animationPhase ""Emergency_lights_switcher"" == 0)"; statement = "this animate [""Turn_lights_switcher"",0]";};
			class Right_turn_lights_on {displayName = "$STR_RAF_2203_right_turn_lights_on"; position = "driver"; radius = 0.5; condition = "(alive this) and (this animationPhase ""Turn_lights_switcher"" == 0.5) and (this animationPhase ""Emergency_lights_switcher"" == 0)"; statement = "this animate [""Turn_lights_switcher"",1]";};
			class Turn_lights_off {displayName = "$STR_RAF_2203_turn_lights_off"; position = "driver"; radius = 0.5; condition = "(alive this) and (this animationPhase ""Turn_lights_switcher"" != 0.5)"; statement = "this animate [""Turn_lights_switcher"",0.5]";};
			class Emergency_lights_on {displayName = "$STR_RAF_2203_emergency_lights_on"; position = "driver"; radius = 0.5; condition = "(alive this) and (this animationPhase ""Emergency_lights_switcher"" == 0) and (this animationPhase ""Turn_lights_switcher"" == 0.5)"; statement = "this animate [""Emergency_lights_switcher"",1]";};
			class Emergency_lights_off {displayName = "$STR_RAF_2203_emergency_lights_off"; position = "driver"; radius = 0.5; condition = "(alive this) and (this animationPhase ""Emergency_lights_switcher"" == 1)"; statement = "this animate [""Emergency_lights_switcher"",0]";};
			class Wipers_on {displayName = "$STR_RAF_2203_wipers_on"; position = "driver"; radius = 0.5; condition = "(alive this) and (this animationPhase ""Wipers_switcher"" == 0)"; statement = "this animate [""Wipers_switcher"",1]";};
			class Wipers_off {displayName = "$STR_RAF_2203_wipers_off"; position = "driver"; radius = 0.5; condition = "(alive this) and (this animationPhase ""Wipers_switcher"" == 1)"; statement = "this animate [""Wipers_switcher"",0]";};
			class Flasher_on {displayName = "$STR_RAF_2203_flasher_on"; position = "driver"; radius = 0.5; condition = "(alive this) and (this animationPhase ""Flasher_switcher"" == 0)"; statement = "this animate [""Flasher_switcher"",1]";};
			class Flasher_off {displayName = "$STR_RAF_2203_flasher_off"; position = "driver"; radius = 0.5; condition = "(alive this) and (this animationPhase ""Flasher_switcher"" == 1)"; statement = "this animate [""Flasher_switcher"",0]";};
			class Siren_on {displayName = "$STR_RAF_2203_siren_on"; position = "driver"; radius = 0.5; condition = "(alive this) and (this animationPhase ""Siren_switcher"" == 0)"; statement = "this animate [""Siren_switcher"",1]";};
			class Siren_off {displayName = "$STR_RAF_2203_siren_off"; position = "driver"; radius = 0.5; condition = "(alive this) and (this animationPhase ""Siren_switcher"" == 1)"; statement = "this animate [""Siren_switcher"",0]";};
			class Handbreak_on {displayName = "$STR_RAF_2203_handbreak_on"; position = "driver"; radius = 0.5; condition = "(alive this) and (this animationPhase ""Handbreak_switcher"" == 0)"; statement = "this animate [""Handbreak_switcher"",1]";};
			class Handbreak_off {displayName = "$STR_RAF_2203_handbreak_off"; position = "driver"; radius = 0.5; condition = "(alive this) and (this animationPhase ""Handbreak_switcher"" == 1)"; statement = "this animate [""Handbreak_switcher"",0]";};
			};
		};

	class RAF_2203_militia: RAF_22031
		{
		side = TEast;
		model = "\RAF-2203\Models\RAF_2203_militia_and_headquarter.p3d";
		hiddenSelections[] = {"color","wheel_covers","wheel_onlays","early_emblem","early_sidelights_mask","later_turn_lights","extra","nothing","nothing","nothing","nothing","nothing","nothing","nothing","nothing","GAI","militia","lab","lab_equipment","headquarter","blazon","seats","compartment","nothing","first_half_of_movement_of_flasher","second_half_of_movement_of_flasher"};
		displayName = "$STR_RAF_2203_militia";
		icon = "\RAF-2203\Textures\Icons\RAF_2203_militia.paa";
		picture = "\RAF-2203\Textures\Pictures\RAF_2203_militia.paa";
		crew = "Civilian11";
		transportSoldier = 8;
		cargoAction[] = {ManActSkodaCoDriverBack};
		maxSpeed = 92;
		nameSound = "car";
		attendant = 0;

		class Animations
			{
			class Dynamic_suspension {type = "rotation"; animperiod = 0.5; selection = "dynamic_suspension"; axis = "dynamic_suspension_axis"; angle0 = -0.1; angle1 = 0.1;};
			class Tilts {type = "rotation"; animperiod = 5; selection = "tilts"; axis = "tilts_axis"; angle0 = 1; angle1 = -1;};
			class Fuel_gauge {type = "rotation"; animPeriod = 1; selection = "fuel_gauge"; axis = "fuel_gauge_axis"; angle0 = 0; angle1 = -1.15;};
			class Inside_sounds_switcher {type = "rotation"; animPeriod = 0.01; selection = "inside_sounds_switcher"; axis = "switchers_axis"; angle0 = 0; angle1 = 3.141592;};
			class Turn_lights_switcher {type = "rotation"; animPeriod = 0.25; selection = "turn_lights_switcher"; axis = "turn_lights_switcher_axis"; angle0 = -0.5; angle1 = 0.5;};
			class Emergency_lights_switcher {type = "rotation"; animPeriod = 0.1; selection = "emergency_lights_switcher"; axis = "emergency_lights_switcher_axis"; angle0 = 0; angle1 = -0.003;};
			class Front_left_turn_light {type = "rotation"; animPeriod = 0.01; selection = "front_left_turn_light"; axis = "front_left_turn_light_axis"; angle0 = 3.141592; angle1 = 0;};
			class Front_right_turn_light {type = "rotation"; animPeriod = 0.01; selection = "front_right_turn_light"; axis = "front_right_turn_light_axis"; angle0 = 3.141592; angle1 = 0;};
			class GAZ_24_front_left_turn_light {type = "rotation"; animPeriod = 0.01; selection = "GAZ_24_front_left_turn_light"; axis = "front_left_turn_light_axis"; angle0 = 3.141592; angle1 = 0;};
			class GAZ_24_front_right_turn_light {type = "rotation"; animPeriod = 0.01; selection = "GAZ_24_front_right_turn_light"; axis = "front_right_turn_light_axis"; angle0 = 3.141592; angle1 = 0;};
			class Side_left_turn_light {type = "rotation"; animPeriod = 0.01; selection = "side_left_turn_light"; axis = "side_left_turn_light_axis"; angle0 = -3.141592; angle1 = 0;};
			class Side_right_turn_light {type = "rotation"; animPeriod = 0.01; selection = "side_right_turn_light"; axis = "side_right_turn_light_axis"; angle0 = 3.141592; angle1 = 0;};
			class Back_left_turn_light {type = "rotation"; animPeriod = 0.01; selection = "back_left_turn_light"; axis = "back_lights_axis"; angle0 = 3.141592; angle1 = 0;};
			class Back_right_turn_light {type = "rotation"; animPeriod = 0.01; selection = "back_right_turn_light"; axis = "back_lights_axis"; angle0 = 3.141592; angle1 = 0;};
			class Turn_lights_indicator {type = "rotation"; animPeriod = 0.01; selection = "turn_lights_indicator"; axis = "turn_lights_indicator_axis"; angle0 = 3.141592; angle1 = 0;};
			class Emergency_lights_indicator {type = "rotation"; animPeriod = 0.01; selection = "emergency_lights_indicator"; axis = "emergency_lights_indicator_axis"; angle0 = -3.141592; angle1 = 0;};
			class Wipers_switcher {type = "rotation"; animPeriod = 0.15; selection = "wipers_switcher"; axis = "wipers_switcher_axis"; angle0 = 0; angle1 = 0.5;};
			class Wiper1 {type = "rotation"; animPeriod = 1.5; selection = "wiper1"; axis = "wiper1_axis"; angle0 = 0; angle1 = -1.8;};
		  	class Wiper2 {type = "rotation"; animPeriod = 1.5; selection = "wiper2"; axis = "wiper2_axis"; angle0 = 0; angle1 = -1.9;};
			class Handbreak_switcher {type = "rotation"; animPeriod = 0.3; selection = "handbreak_switcher"; axis = "handbreak_switcher_axis"; angle0 = 0; angle1 = 0.7;};
			class Handbreak_indicator {type = "rotation"; animPeriod = 0.01; selection = "handbreak_indicator"; axis = "handbreak_indicator_axis"; angle0 = 3.141592; angle1 = 0;};
			class Reversing_lights {type = "rotation"; animPeriod = 0.01; selection = "reversing_lights"; axis = "back_lights_axis"; angle0 = 3.141592; angle1 = 0;};
			class Flasher_switcher {type = "rotation"; animPeriod = 0.1; selection = "flasher_switcher"; axis = "switchers_axis"; angle0 = 0; angle1 = 3.141592;};
			class First_half_of_movement_of_flasher {type = "rotation"; animPeriod = 0.3; selection = "first_half_of_movement_of_flasher"; axis = "flasher_axis"; angle0 = 0; angle1 = -3.141592;};
			class Second_half_of_movement_of_flasher {type = "rotation"; animPeriod = 0.3; selection = "second_half_of_movement_of_flasher"; axis = "flasher_axis"; angle0 = 0; angle1 = -3.141592;};
			class Siren_switcher {type = "rotation"; animPeriod = 0.1; selection = "siren_switcher"; axis = "switchers_axis"; angle0 = 0; angle1 = 3.141592;};
			class Lights_breaking {type = "rotation"; animPeriod = 0.01; selection = "lights_breaking"; axis = "lights_breaking_axis"; angle0 = 0; angle1 = 3.141592;};
			};
		};

	class RAF_2203_headquarter: RAF_2203_militia
		{
		displayName = "$STR_RAF_2203_headquarter";
		icon = "\RAF-2203\Textures\Icons\RAF_2203_headquarter.paa";
		picture = "\RAF-2203\Textures\Pictures\RAF_2203_headquarter.paa";
		crew = "Civilian6";
		weapons[] = {"RAF_2203_klaxon","RAF_2203_wheel_covers","RAF_2203_headquarter_inscriptions"};
		maxSpeed = 88;
		};

	class TAMRO_RAF_reanimation: RAF_22031
		{
		model = "\RAF-2203\Models\TAMRO_RAF_reanimation.p3d";
		hiddenSelections[] = {"nothing","wheel_covers","wheel_onlays","nothing","nothing","nothing","extra","nothing","nothing","nothing","nothing","nothing","nothing","SMP","nothing","GAI","nothing","nothing","nothing","nothing","nothing","nothing","nothing","nothing","first_half_of_movement_of_flasher","second_half_of_movement_of_flasher"};
		displayName = "$STR_TAMRO_RAF_reanimation";
		icon = "\RAF-2203\Textures\Icons\TAMRO_RAF_reanimation.paa";
		picture = "\RAF-2203\Textures\Pictures\TAMRO_RAF_reanimation.paa";
		maxSpeed = 80;
		dammageHalf[] = {"\RAF-2203\Textures\Glass.paa","\RAF-2203\Textures\Glass_1.paa","\RAF-2203\Textures\TAMRO_gl.paa","\RAF-2203\Textures\TAMRO_gl1.paa"};
		dammageFull[] = {"\RAF-2203\Textures\Glass.paa","\RAF-2203\Textures\Glass_2.paa","\RAF-2203\Textures\TAMRO_gl.paa","\RAF-2203\Textures\TAMRO_gl1.paa"};

		class Animations
			{
			class Dynamic_suspension {type = "rotation"; animperiod = 0.5; selection = "dynamic_suspension"; axis = "dynamic_suspension_axis"; angle0 = -0.1; angle1 = 0.1;};
			class Tilts {type = "rotation"; animperiod = 5; selection = "tilts"; axis = "tilts_axis"; angle0 = 1; angle1 = -1;};
			class Fuel_gauge {type = "rotation"; animPeriod = 1; selection = "fuel_gauge"; axis = "fuel_gauge_axis"; angle0 = 0; angle1 = -1.15;};
			class Inside_sounds_switcher {type = "rotation"; animPeriod = 0.01; selection = "inside_sounds_switcher"; axis = "switchers_axis"; angle0 = 0; angle1 = 3.141592;};
			class Turn_lights_switcher {type = "rotation"; animPeriod = 0.25; selection = "turn_lights_switcher"; axis = "turn_lights_switcher_axis"; angle0 = -0.5; angle1 = 0.5;};
			class Emergency_lights_switcher {type = "rotation"; animPeriod = 0.1; selection = "emergency_lights_switcher"; axis = "emergency_lights_switcher_axis"; angle0 = 0; angle1 = -0.003;};
			class Front_left_turn_light {type = "rotation"; animPeriod = 0.01; selection = "front_left_turn_light"; axis = "front_left_turn_light_axis"; angle0 = 3.141592; angle1 = 0;};
			class Front_right_turn_light {type = "rotation"; animPeriod = 0.01; selection = "front_right_turn_light"; axis = "front_right_turn_light_axis"; angle0 = 3.141592; angle1 = 0;};
			class Side_left_turn_light {type = "rotation"; animPeriod = 0.01; selection = "side_left_turn_light"; axis = "side_left_turn_light_axis"; angle0 = -3.141592; angle1 = 0;};
			class Side_right_turn_light {type = "rotation"; animPeriod = 0.01; selection = "side_right_turn_light"; axis = "side_right_turn_light_axis"; angle0 = 3.141592; angle1 = 0;};
			class Back_left_turn_light {type = "rotation"; animPeriod = 0.01; selection = "back_left_turn_light"; axis = "back_lights_axis"; angle0 = 3.141592; angle1 = 0;};
			class Back_right_turn_light {type = "rotation"; animPeriod = 0.01; selection = "back_right_turn_light"; axis = "back_lights_axis"; angle0 = 3.141592; angle1 = 0;};
			class Back_top_left_turn_light {type = "rotation"; animPeriod = 0.01; selection = "back_top_left_turn_light"; axis = "back_top_left_turn_light_axis"; angle0 = 3.141592; angle1 = 0;};
			class Back_top_right_turn_light {type = "rotation"; animPeriod = 0.01; selection = "back_top_right_turn_light"; axis = "back_top_right_turn_light_axis"; angle0 = 3.141592; angle1 = 0;};
			class Turn_lights_indicator {type = "rotation"; animPeriod = 0.01; selection = "turn_lights_indicator"; axis = "turn_lights_indicator_axis"; angle0 = 3.141592; angle1 = 0;};
			class Emergency_lights_indicator {type = "rotation"; animPeriod = 0.01; selection = "emergency_lights_indicator"; axis = "emergency_lights_indicator_axis"; angle0 = -3.141592; angle1 = 0;};
			class Wipers_switcher {type = "rotation"; animPeriod = 0.15; selection = "wipers_switcher"; axis = "wipers_switcher_axis"; angle0 = 0; angle1 = 0.5;};
			class Wiper1 {type = "rotation"; animPeriod = 1.5; selection = "wiper1"; axis = "wiper1_axis"; angle0 = 0; angle1 = -1.8;};
		  	class Wiper2 {type = "rotation"; animPeriod = 1.5; selection = "wiper2"; axis = "wiper2_axis"; angle0 = 0; angle1 = -1.9;};
			class Handbreak_switcher {type = "rotation"; animPeriod = 0.3; selection = "handbreak_switcher"; axis = "handbreak_switcher_axis"; angle0 = 0; angle1 = 0.7;};
			class Handbreak_indicator {type = "rotation"; animPeriod = 0.01; selection = "handbreak_indicator"; axis = "handbreak_indicator_axis"; angle0 = 3.141592; angle1 = 0;};
			class Reversing_lights {type = "rotation"; animPeriod = 0.01; selection = "reversing_lights"; axis = "back_lights_axis"; angle0 = 3.141592; angle1 = 0;};
			class Flasher_switcher {type = "rotation"; animPeriod = 0.1; selection = "flasher_switcher"; axis = "switchers_axis"; angle0 = 0; angle1 = 3.141592;};
			class Flasher_indicator {type = "rotation"; animPeriod = 0.01; selection = "flasher_indicator"; axis = "flasher_indicator_axis"; angle0 = 3.141592; angle1 = 0;};
			class First_half_of_movement_of_flasher {type = "rotation"; animPeriod = 0.3; selection = "first_half_of_movement_of_flasher"; axis = "flasher_axis"; angle0 = 0; angle1 = -3.141592;};
			class Second_half_of_movement_of_flasher {type = "rotation"; animPeriod = 0.3; selection = "second_half_of_movement_of_flasher"; axis = "flasher_axis"; angle0 = 0; angle1 = -3.141592;};
			class Flasher1 {type = "rotation"; animPeriod = 0.01; selection = "flasher1"; axis = "flashers_axis"; angle0 = 3.141592; angle1 = 0;};
			class Flasher2 {type = "rotation"; animPeriod = 0.01; selection = "flasher2"; axis = "flashers_axis"; angle0 = 3.141592; angle1 = 0;};
			class Flasher3 {type = "rotation"; animPeriod = 0.01; selection = "flasher3"; axis = "flashers_axis"; angle0 = 3.141592; angle1 = 0;};
			class Flasher4 {type = "rotation"; animPeriod = 0.01; selection = "flasher4"; axis = "flashers_axis"; angle0 = 3.141592; angle1 = 0;};
			class Flasher5 {type = "rotation"; animPeriod = 0.01; selection = "flasher5"; axis = "flasher5_axis"; angle0 = 3.141592; angle1 = 0;};
			class Siren_switcher {type = "rotation"; animPeriod = 0.1; selection = "siren_switcher"; axis = "switchers_axis"; angle0 = 0; angle1 = 3.141592;};
			class Lights_breaking {type = "rotation"; animPeriod = 0.01; selection = "lights_breaking"; axis = "lights_breaking_axis"; angle0 = 0; angle1 = 3.141592;};
			};

		class UserActions
			{		
			class Left_turn_lights_on {displayName = "$STR_RAF_2203_left_turn_lights_on"; position = "driver"; radius = 0.5; condition = "(alive this) and (this animationPhase ""Turn_lights_switcher"" == 0.5) and (this animationPhase ""Emergency_lights_switcher"" == 0)"; statement = "this animate [""Turn_lights_switcher"",0]";};
			class Right_turn_lights_on {displayName = "$STR_RAF_2203_right_turn_lights_on"; position = "driver"; radius = 0.5; condition = "(alive this) and (this animationPhase ""Turn_lights_switcher"" == 0.5) and (this animationPhase ""Emergency_lights_switcher"" == 0)"; statement = "this animate [""Turn_lights_switcher"",1]";};
			class Turn_lights_off {displayName = "$STR_RAF_2203_turn_lights_off"; position = "driver"; radius = 0.5; condition = "(alive this) and (this animationPhase ""Turn_lights_switcher"" != 0.5)"; statement = "this animate [""Turn_lights_switcher"",0.5]";};
			class Emergency_lights_on {displayName = "$STR_RAF_2203_emergency_lights_on"; position = "driver"; radius = 0.5; condition = "(alive this) and (this animationPhase ""Emergency_lights_switcher"" == 0) and (this animationPhase ""Turn_lights_switcher"" == 0.5)"; statement = "this animate [""Emergency_lights_switcher"",1]";};
			class Emergency_lights_off {displayName = "$STR_RAF_2203_emergency_lights_off"; position = "driver"; radius = 0.5; condition = "(alive this) and (this animationPhase ""Emergency_lights_switcher"" == 1)"; statement = "this animate [""Emergency_lights_switcher"",0]";};
			class Wipers_on {displayName = "$STR_RAF_2203_wipers_on"; position = "driver"; radius = 0.5; condition = "(alive this) and (this animationPhase ""Wipers_switcher"" == 0)"; statement = "this animate [""Wipers_switcher"",1]";};
			class Wipers_off {displayName = "$STR_RAF_2203_wipers_off"; position = "driver"; radius = 0.5; condition = "(alive this) and (this animationPhase ""Wipers_switcher"" == 1)"; statement = "this animate [""Wipers_switcher"",0]";};
			class Flashers_on {displayName = "$STR_RAF_2203_flashers_on"; position = "driver"; radius = 0.5; condition = "(alive this) and (this animationPhase ""Flasher_switcher"" == 0)"; statement = "this animate [""Flasher_switcher"",1]";};
			class Flashers_off {displayName = "$STR_RAF_2203_flashers_off"; position = "driver"; radius = 0.5; condition = "(alive this) and (this animationPhase ""Flasher_switcher"" == 1)"; statement = "this animate [""Flasher_switcher"",0]";};
			class Siren_on {displayName = "$STR_RAF_2203_siren_on"; position = "driver"; radius = 0.5; condition = "(alive this) and (this animationPhase ""Siren_switcher"" == 0)"; statement = "this animate [""Siren_switcher"",1]";};
			class Siren_off {displayName = "$STR_RAF_2203_siren_off"; position = "driver"; radius = 0.5; condition = "(alive this) and (this animationPhase ""Siren_switcher"" == 1)"; statement = "this animate [""Siren_switcher"",0]";};
			class Handbreak_on {displayName = "$STR_RAF_2203_handbreak_on"; position = "driver"; radius = 0.5; condition = "(alive this) and (this animationPhase ""Handbreak_switcher"" == 0)"; statement = "this animate [""Handbreak_switcher"",1]";};
			class Handbreak_off {displayName = "$STR_RAF_2203_handbreak_off"; position = "driver"; radius = 0.5; condition = "(alive this) and (this animationPhase ""Handbreak_switcher"" == 1)"; statement = "this animate [""Handbreak_switcher"",0]";};
			};
		};

	class RAF_2203_01_blue: RAF_2203_blue
		{
		model = "\RAF-2203\Models\RAF_2203_01.p3d";
		hiddenSelections[] = {"color","wheel_covers","wheel_onlays","nothing","nothing","nothing","extra","nothing","nothing","taxi","Aeroflot","television"};
		displayName = "$STR_RAF_2203_01_blue";
		icon = "\RAF-2203\Textures\Icons\RAF_2203_01.paa";
		picture = "\RAF-2203\Textures\Pictures\RAF_2203_01_blue.paa";
		weapons[] = {"RAF_2203_klaxon","RAF_2203_wheel_onlays"};
		maxSpeed = 93;
		
		class Animations
			{
			class Dynamic_suspension {type = "rotation"; animperiod = 0.5; selection = "dynamic_suspension"; axis = "dynamic_suspension_axis"; angle0 = -0.1; angle1 = 0.1;};
			class Tilts {type = "rotation"; animperiod = 5; selection = "tilts"; axis = "tilts_axis"; angle0 = 1; angle1 = -1;};
			class Fuel_gauge {type = "rotation"; animPeriod = 3; selection = "fuel_gauge"; axis = "fuel_gauge_axis"; angle0 = 0; angle1 = -1.15;};
			class Inside_sounds_switcher {type = "rotation"; animPeriod = 0.01; selection = "inside_sounds_switcher"; axis = "switchers_axis"; angle0 = 0; angle1 = 3.141592;};
			class Turn_lights_switcher {type = "rotation"; animPeriod = 0.25; selection = "turn_lights_switcher"; axis = "turn_lights_switcher_axis"; angle0 = -0.5; angle1 = 0.5;};
			class Emergency_lights_switcher {type = "rotation"; animPeriod = 0.1; selection = "emergency_lights_switcher"; axis = "emergency_lights_switcher_axis"; angle0 = 0; angle1 = -0.003;};
			class Front_left_turn_light {type = "rotation"; animPeriod = 0.01; selection = "front_left_turn_light"; axis = "front_lights_axis"; angle0 = 3.141592; angle1 = 0;};
			class Front_right_turn_light {type = "rotation"; animPeriod = 0.01; selection = "front_right_turn_light"; axis = "front_lights_axis"; angle0 = 3.141592; angle1 = 0;};
			class Side_left_turn_light {type = "rotation"; animPeriod = 0.01; selection = "side_left_turn_light"; axis = "side_left_turn_light_axis"; angle0 = -3.141592; angle1 = 0;};
			class Side_right_turn_light {type = "rotation"; animPeriod = 0.01; selection = "side_right_turn_light"; axis = "side_right_turn_light_axis"; angle0 = 3.141592; angle1 = 0;};
			class Back_left_turn_light {type = "rotation"; animPeriod = 0.01; selection = "back_left_turn_light"; axis = "back_lights_axis"; angle0 = 3.141592; angle1 = 0;};
			class Back_right_turn_light {type = "rotation"; animPeriod = 0.01; selection = "back_right_turn_light"; axis = "back_lights_axis"; angle0 = 3.141592; angle1 = 0;};
			class Turn_lights_indicator {type = "rotation"; animPeriod = 0.01; selection = "turn_lights_indicator"; axis = "turn_lights_indicator_axis"; angle0 = 3.141592; angle1 = 0;};
			class Emergency_lights_indicator {type = "rotation"; animPeriod = 0.01; selection = "emergency_lights_indicator"; axis = "emergency_lights_indicator_axis"; angle0 = -3.141592; angle1 = 0;};
			class Wipers_switcher {type = "rotation"; animPeriod = 0.15; selection = "wipers_switcher"; axis = "wipers_switcher_axis"; angle0 = 0; angle1 = 0.5;};
			class Wiper1 {type = "rotation"; animPeriod = 1.5; selection = "wiper1"; axis = "wiper1_axis"; angle0 = 0; angle1 = -1.7;};
		  	class Wiper2 {type = "rotation"; animPeriod = 1.5; selection = "wiper2"; axis = "wiper2_axis"; angle0 = 0; angle1 = -2;};
			class Handbreak_switcher {type = "rotation"; animPeriod = 0.3; selection = "handbreak_switcher"; axis = "handbreak_switcher_axis"; angle0 = 0; angle1 = 0.7;};
			class Handbreak_indicator {type = "rotation"; animPeriod = 0.01; selection = "handbreak_indicator"; axis = "handbreak_indicator_axis"; angle0 = 3.141592; angle1 = 0;};
			class Reversing_lights {type = "rotation"; animPeriod = 0.01; selection = "reversing_lights"; axis = "back_lights_axis"; angle0 = 3.141592; angle1 = 0;};
			class Lights_breaking {type = "rotation"; animPeriod = 0.01; selection = "lights_breaking"; axis = "lights_breaking_axis"; angle0 = 0; angle1 = 3.141592;};
			};
		};

	class RAF_2203_01_white: RAF_2203_01_blue
		{
		displayName = "$STR_RAF_2203_01_white";
		picture = "\RAF-2203\Textures\Pictures\RAF_2203_01_white.paa";
		};

	class RAF_2203_01_yellow: RAF_2203_01_blue
		{
		displayName = "$STR_RAF_2203_01_yellow";
		picture = "\RAF-2203\Textures\Pictures\RAF_2203_01_yellow.paa";
		};

	class RAF_2203_01_bright_green: RAF_2203_01_blue
		{
		displayName = "$STR_RAF_2203_01_bright_green";
		picture = "\RAF-2203\Textures\Pictures\RAF_2203_01_bright_green.paa";
		};

	class RAF_2203_01_dark_green: RAF_2203_01_blue
		{
		displayName = "$STR_RAF_2203_01_dark_green";
		picture = "\RAF-2203\Textures\Pictures\RAF_2203_01_dark_green.paa";
		};

	class RAF_2203_01_red: RAF_2203_01_blue
		{
		displayName = "$STR_RAF_2203_01_red";
		picture = "\RAF-2203\Textures\Pictures\RAF_2203_01_red.paa";
		};

	class RAF_2203_01_azure: RAF_2203_01_blue
		{
		displayName = "$STR_RAF_2203_01_azure";
		picture = "\RAF-2203\Textures\Pictures\RAF_2203_01_azure.paa";
		};

	class RAF_22031_01: RAF_22031
		{
		model = "\RAF-2203\Models\RAF_22031_01.p3d";
		hiddenSelections[] = {"nothing","wheel_covers","wheel_onlays","nothing","nothing","nothing","extra","nothing","nothing","nothing","nothing","nothing","nothing","SMP","PMP","GAI","nothing","nothing","nothing","nothing","nothing","nothing","nothing","nothing","first_half_of_movement_of_flasher","second_half_of_movement_of_flasher"};
		displayName = "$STR_RAF_22031_01";
		icon = "\RAF-2203\Textures\Icons\RAF_22031_01.paa";
		picture = "\RAF-2203\Textures\Pictures\RAF_22031_01.paa";
		weapons[] = {"RAF_2203_klaxon","RAF_2203_wheel_onlays"};
		maxSpeed = 90;

		class Animations
			{
			class Dynamic_suspension {type = "rotation"; animperiod = 0.5; selection = "dynamic_suspension"; axis = "dynamic_suspension_axis"; angle0 = -0.1; angle1 = 0.1;};
			class Tilts {type = "rotation"; animperiod = 5; selection = "tilts"; axis = "tilts_axis"; angle0 = 1; angle1 = -1;};
			class Fuel_gauge {type = "rotation"; animPeriod = 1; selection = "fuel_gauge"; axis = "fuel_gauge_axis"; angle0 = 0; angle1 = -1.15;};
			class Inside_sounds_switcher {type = "rotation"; animPeriod = 0.01; selection = "inside_sounds_switcher"; axis = "switchers_axis"; angle0 = 0; angle1 = 3.141592;};
			class Turn_lights_switcher {type = "rotation"; animPeriod = 0.25; selection = "turn_lights_switcher"; axis = "turn_lights_switcher_axis"; angle0 = -0.5; angle1 = 0.5;};
			class Emergency_lights_switcher {type = "rotation"; animPeriod = 0.1; selection = "emergency_lights_switcher"; axis = "emergency_lights_switcher_axis"; angle0 = 0; angle1 = -0.003;};
			class Front_left_turn_light {type = "rotation"; animPeriod = 0.01; selection = "front_left_turn_light"; axis = "front_lights_axis"; angle0 = 3.141592; angle1 = 0;};
			class Front_right_turn_light {type = "rotation"; animPeriod = 0.01; selection = "front_right_turn_light"; axis = "front_lights_axis"; angle0 = 3.141592; angle1 = 0;};
			class Side_left_turn_light {type = "rotation"; animPeriod = 0.01; selection = "side_left_turn_light"; axis = "side_left_turn_light_axis"; angle0 = -3.141592; angle1 = 0;};
			class Side_right_turn_light {type = "rotation"; animPeriod = 0.01; selection = "side_right_turn_light"; axis = "side_right_turn_light_axis"; angle0 = 3.141592; angle1 = 0;};
			class Back_left_turn_light {type = "rotation"; animPeriod = 0.01; selection = "back_left_turn_light"; axis = "back_lights_axis"; angle0 = 3.141592; angle1 = 0;};
			class Back_right_turn_light {type = "rotation"; animPeriod = 0.01; selection = "back_right_turn_light"; axis = "back_lights_axis"; angle0 = 3.141592; angle1 = 0;};
			class Turn_lights_indicator {type = "rotation"; animPeriod = 0.01; selection = "turn_lights_indicator"; axis = "turn_lights_indicator_axis"; angle0 = 3.141592; angle1 = 0;};
			class Emergency_lights_indicator {type = "rotation"; animPeriod = 0.01; selection = "emergency_lights_indicator"; axis = "emergency_lights_indicator_axis"; angle0 = -3.141592; angle1 = 0;};
			class Wipers_switcher {type = "rotation"; animPeriod = 0.15; selection = "wipers_switcher"; axis = "wipers_switcher_axis"; angle0 = 0; angle1 = 0.5;};
			class Wiper1 {type = "rotation"; animPeriod = 1.5; selection = "wiper1"; axis = "wiper1_axis"; angle0 = 0; angle1 = -1.8;};
		  	class Wiper2 {type = "rotation"; animPeriod = 1.5; selection = "wiper2"; axis = "wiper2_axis"; angle0 = 0; angle1 = -2;};
			class Handbreak_switcher {type = "rotation"; animPeriod = 0.3; selection = "handbreak_switcher"; axis = "handbreak_switcher_axis"; angle0 = 0; angle1 = 0.7;};
			class Handbreak_indicator {type = "rotation"; animPeriod = 0.01; selection = "handbreak_indicator"; axis = "handbreak_indicator_axis"; angle0 = 3.141592; angle1 = 0;};
			class Reversing_lights {type = "rotation"; animPeriod = 0.01; selection = "reversing_lights"; axis = "back_lights_axis"; angle0 = 3.141592; angle1 = 0;};
			class Flasher_switcher {type = "rotation"; animPeriod = 0.1; selection = "flasher_switcher"; axis = "switchers_axis"; angle0 = 0; angle1 = 3.141592;};
			class First_half_of_movement_of_flasher {type = "rotation"; animPeriod = 0.2; selection = "first_half_of_movement_of_flasher"; axis = "flasher_axis"; angle0 = 0; angle1 = -3.141592;};
			class Second_half_of_movement_of_flasher {type = "rotation"; animPeriod = 0.2; selection = "second_half_of_movement_of_flasher"; axis = "flasher_axis"; angle0 = 0; angle1 = -3.141592;};
			class Flasher_indicator {type = "rotation"; animPeriod = 0.01; selection = "flasher_indicator"; axis = "flasher_indicator_axis"; angle0 = 3.141592; angle1 = 0;};
			class Siren_switcher {type = "rotation"; animPeriod = 0.1; selection = "siren_switcher"; axis = "switchers_axis"; angle0 = 0; angle1 = 3.141592;};
			class Lights_breaking {type = "rotation"; animPeriod = 0.01; selection = "lights_breaking"; axis = "lights_breaking_axis"; angle0 = 0; angle1 = 3.141592;};
			};
		};

	class RAF_2203_01_militia: RAF_2203_militia
		{
		model = "\RAF-2203\Models\RAF_2203_01_militia_and_headquarter.p3d";
		hiddenSelections[] = {"color","wheel_covers","wheel_onlays","nothing","nothing","nothing","extra","nothing","nothing","nothing","nothing","nothing","nothing","nothing","nothing","GAI","militia","lab","lab_equipment","headquarter","nothing","seats","compartment","nothing","first_half_of_movement_of_flasher","second_half_of_movement_of_flasher"};
		displayName = "$STR_RAF_2203_01_militia";
		icon = "\RAF-2203\Textures\Icons\RAF_2203_01_militia.paa";
		picture = "\RAF-2203\Textures\Pictures\RAF_2203_01_militia.paa";
		weapons[] = {"RAF_2203_klaxon","RAF_2203_wheel_onlays"};

		class Animations
			{
			class Dynamic_suspension {type = "rotation"; animperiod = 0.5; selection = "dynamic_suspension"; axis = "dynamic_suspension_axis"; angle0 = -0.1; angle1 = 0.1;};
			class Tilts {type = "rotation"; animperiod = 5; selection = "tilts"; axis = "tilts_axis"; angle0 = 1; angle1 = -1;};
			class Fuel_gauge {type = "rotation"; animPeriod = 1; selection = "fuel_gauge"; axis = "fuel_gauge_axis"; angle0 = 0; angle1 = -1.15;};
			class Inside_sounds_switcher {type = "rotation"; animPeriod = 0.01; selection = "inside_sounds_switcher"; axis = "switchers_axis"; angle0 = 0; angle1 = 3.141592;};
			class Turn_lights_switcher {type = "rotation"; animPeriod = 0.25; selection = "turn_lights_switcher"; axis = "turn_lights_switcher_axis"; angle0 = -0.5; angle1 = 0.5;};
			class Emergency_lights_switcher {type = "rotation"; animPeriod = 0.1; selection = "emergency_lights_switcher"; axis = "emergency_lights_switcher_axis"; angle0 = 0; angle1 = -0.003;};
			class Front_left_turn_light {type = "rotation"; animPeriod = 0.01; selection = "front_left_turn_light"; axis = "front_lights_axis"; angle0 = 3.141592; angle1 = 0;};
			class Front_right_turn_light {type = "rotation"; animPeriod = 0.01; selection = "front_right_turn_light"; axis = "front_lights_axis"; angle0 = 3.141592; angle1 = 0;};
			class Side_left_turn_light {type = "rotation"; animPeriod = 0.01; selection = "side_left_turn_light"; axis = "side_left_turn_light_axis"; angle0 = -3.141592; angle1 = 0;};
			class Side_right_turn_light {type = "rotation"; animPeriod = 0.01; selection = "side_right_turn_light"; axis = "side_right_turn_light_axis"; angle0 = 3.141592; angle1 = 0;};
			class Back_left_turn_light {type = "rotation"; animPeriod = 0.01; selection = "back_left_turn_light"; axis = "back_lights_axis"; angle0 = 3.141592; angle1 = 0;};
			class Back_right_turn_light {type = "rotation"; animPeriod = 0.01; selection = "back_right_turn_light"; axis = "back_lights_axis"; angle0 = 3.141592; angle1 = 0;};
			class Turn_lights_indicator {type = "rotation"; animPeriod = 0.01; selection = "turn_lights_indicator"; axis = "turn_lights_indicator_axis"; angle0 = 3.141592; angle1 = 0;};
			class Emergency_lights_indicator {type = "rotation"; animPeriod = 0.01; selection = "emergency_lights_indicator"; axis = "emergency_lights_indicator_axis"; angle0 = -3.141592; angle1 = 0;};
			class Wipers_switcher {type = "rotation"; animPeriod = 0.15; selection = "wipers_switcher"; axis = "wipers_switcher_axis"; angle0 = 0; angle1 = 0.5;};
			class Wiper1 {type = "rotation"; animPeriod = 1.5; selection = "wiper1"; axis = "wiper1_axis"; angle0 = 0; angle1 = -1.7;};
		  	class Wiper2 {type = "rotation"; animPeriod = 1.5; selection = "wiper2"; axis = "wiper2_axis"; angle0 = 0; angle1 = -1.9;};
			class Handbreak_switcher {type = "rotation"; animPeriod = 0.3; selection = "handbreak_switcher"; axis = "handbreak_switcher_axis"; angle0 = 0; angle1 = 0.7;};
			class Handbreak_indicator {type = "rotation"; animPeriod = 0.01; selection = "handbreak_indicator"; axis = "handbreak_indicator_axis"; angle0 = 3.141592; angle1 = 0;};
			class Reversing_lights {type = "rotation"; animPeriod = 0.01; selection = "reversing_lights"; axis = "back_lights_axis"; angle0 = 3.141592; angle1 = 0;};
			class Flasher_switcher {type = "rotation"; animPeriod = 0.1; selection = "flasher_switcher"; axis = "switchers_axis"; angle0 = 0; angle1 = 3.141592;};
			class First_half_of_movement_of_flasher {type = "rotation"; animPeriod = 0.3; selection = "first_half_of_movement_of_flasher"; axis = "flasher_axis"; angle0 = 0; angle1 = -3.141592;};
			class Second_half_of_movement_of_flasher {type = "rotation"; animPeriod = 0.3; selection = "second_half_of_movement_of_flasher"; axis = "flasher_axis"; angle0 = 0; angle1 = -3.141592;};
			class Siren_switcher {type = "rotation"; animPeriod = 0.1; selection = "siren_switcher"; axis = "switchers_axis"; angle0 = 0; angle1 = 3.141592;};
			class Lights_breaking {type = "rotation"; animPeriod = 0.01; selection = "lights_breaking"; axis = "lights_breaking_axis"; angle0 = 0; angle1 = 3.141592;};
			};
		};

	class RAF_2203_01_headquarter: RAF_2203_01_militia
		{
		displayName = "$STR_RAF_2203_01_headquarter";
		icon = "\RAF-2203\Textures\Icons\RAF_2203_01_headquarter.paa";
		picture = "\RAF-2203\Textures\Pictures\RAF_2203_01_headquarter.paa";
		crew = "Civilian6";
		};

	class RAF_2914_01_reanimation: TAMRO_RAF_reanimation
		{
		model = "\RAF-2203\Models\RAF_2914_01_reanimation.p3d";
		displayName = "$STR_RAF_2914_01_reanimation";
		icon = "\RAF-2203\Textures\Icons\RAF_2914_01_reanimation.paa";
		picture = "\RAF-2203\Textures\Pictures\RAF_2914_01_reanimation.paa";
		weapons[] = {"RAF_2203_klaxon","RAF_2203_wheel_onlays"};
		maxSpeed = 80;
		dammageHalf[] = {"\RAF-2203\Textures\Glass.paa","\RAF-2203\Textures\Glass_1.paa","\RAF-2203\Textures\Amb_gl.paa","\RAF-2203\Textures\Amb_gl1.paa","\RAF-2203\Textures\Amb_gl2.paa","\RAF-2203\Textures\Amb_gl3.paa","\RAF-2203\Textures\Amb_gl4.paa","\RAF-2203\Textures\Amb_gl5.paa"};
		dammageFull[] = {"\RAF-2203\Textures\Glass.paa","\RAF-2203\Textures\Glass_2.paa","\RAF-2203\Textures\Amb_gl.paa","\Data\Jeep_kab_sklo2c.paa","\RAF-2203\Textures\Amb_gl2.paa","\RAF-2203\Textures\Amb_gl3.paa","\RAF-2203\Textures\Amb_gl4.paa","\RAF-2203\Textures\Amb_gl5.paa"};

		class Reflectors
 			{
   			class Left {color[] = {1.0,0.9,0.6,0.35}; ambient[]={1.0,0.9,0.6,0.35}; position = "L svetlo"; direction = "konec L svetla"; hitpoint = "L svetlo"; selection = "L svetlo"; size = 0.5; brightness = 0.25;};
   			class Right {color[] = {1.0,0.9,0.6,0.35}; ambient[]={1.0,0.9,0.6,0.35}; position = "P svetlo"; direction = "konec P svetla"; hitpoint = "P svetlo"; selection = "P svetlo"; size = 0.5; brightness = 0.25;};
			};

		class Animations
			{
			class Dynamic_suspension {type = "rotation"; animperiod = 0.5; selection = "dynamic_suspension"; axis = "dynamic_suspension_axis"; angle0 = -0.1; angle1 = 0.1;};
			class Tilts {type = "rotation"; animperiod = 5; selection = "tilts"; axis = "tilts_axis"; angle0 = 1; angle1 = -1;};
			class Fuel_gauge {type = "rotation"; animPeriod = 1; selection = "fuel_gauge"; axis = "fuel_gauge_axis"; angle0 = 0; angle1 = -1.15;};
			class Inside_sounds_switcher {type = "rotation"; animPeriod = 0.01; selection = "inside_sounds_switcher"; axis = "switchers_axis"; angle0 = 0; angle1 = 3.141592;};
			class Turn_lights_switcher {type = "rotation"; animPeriod = 0.25; selection = "turn_lights_switcher"; axis = "turn_lights_switcher_axis"; angle0 = -0.5; angle1 = 0.5;};
			class Emergency_lights_switcher {type = "rotation"; animPeriod = 0.1; selection = "emergency_lights_switcher"; axis = "emergency_lights_switcher_axis"; angle0 = 0; angle1 = -0.003;};
			class Front_left_turn_light {type = "rotation"; animPeriod = 0.01; selection = "front_left_turn_light"; axis = "front_lights_axis"; angle0 = 3.141592; angle1 = 0;};
			class Front_right_turn_light {type = "rotation"; animPeriod = 0.01; selection = "front_right_turn_light"; axis = "front_lights_axis"; angle0 = 3.141592; angle1 = 0;};
			class Side_left_turn_light {type = "rotation"; animPeriod = 0.01; selection = "side_left_turn_light"; axis = "side_left_turn_light_axis"; angle0 = -3.141592; angle1 = 0;};
			class Side_right_turn_light {type = "rotation"; animPeriod = 0.01; selection = "side_right_turn_light"; axis = "side_right_turn_light_axis"; angle0 = 3.141592; angle1 = 0;};
			class Back_left_turn_light {type = "rotation"; animPeriod = 0.01; selection = "back_left_turn_light"; axis = "back_lights_axis"; angle0 = 3.141592; angle1 = 0;};
			class Back_right_turn_light {type = "rotation"; animPeriod = 0.01; selection = "back_right_turn_light"; axis = "back_lights_axis"; angle0 = 3.141592; angle1 = 0;};
			class Turn_lights_indicator {type = "rotation"; animPeriod = 0.01; selection = "turn_lights_indicator"; axis = "turn_lights_indicator_axis"; angle0 = 3.141592; angle1 = 0;};
			class Emergency_lights_indicator {type = "rotation"; animPeriod = 0.01; selection = "emergency_lights_indicator"; axis = "emergency_lights_indicator_axis"; angle0 = -3.141592; angle1 = 0;};
			class Wipers_switcher {type = "rotation"; animPeriod = 0.15; selection = "wipers_switcher"; axis = "wipers_switcher_axis"; angle0 = 0; angle1 = 0.5;};
			class Wiper1 {type = "rotation"; animPeriod = 1.5; selection = "wiper1"; axis = "wiper1_axis"; angle0 = 0; angle1 = -1.7;};
		  	class Wiper2 {type = "rotation"; animPeriod = 1.5; selection = "wiper2"; axis = "wiper2_axis"; angle0 = 0; angle1 = -1.9;};
			class Handbreak_switcher {type = "rotation"; animPeriod = 0.3; selection = "handbreak_switcher"; axis = "handbreak_switcher_axis"; angle0 = 0; angle1 = 0.7;};
			class Handbreak_indicator {type = "rotation"; animPeriod = 0.01; selection = "handbreak_indicator"; axis = "handbreak_indicator_axis"; angle0 = 3.141592; angle1 = 0;};
			class Reversing_lights {type = "rotation"; animPeriod = 0.01; selection = "reversing_lights"; axis = "back_lights_axis"; angle0 = 3.141592; angle1 = 0;};
			class Flasher_switcher {type = "rotation"; animPeriod = 0.1; selection = "flasher_switcher"; axis = "switchers_axis"; angle0 = 0; angle1 = 3.141592;};
			class Flasher_indicator {type = "rotation"; animPeriod = 0.01; selection = "flasher_indicator"; axis = "flasher_indicator_axis"; angle0 = 3.141592; angle1 = 0;};
			class Flasher1 {type = "rotation"; animPeriod = 0.01; selection = "flasher1"; axis = "flasher1_axis"; angle0 = 3.141592; angle1 = 0;};
			class Flasher2 {type = "rotation"; animPeriod = 0.01; selection = "flasher2"; axis = "flasher2_axis"; angle0 = 3.141592; angle1 = 0;};
			class Flasher3 {type = "rotation"; animPeriod = 0.01; selection = "flasher3"; axis = "flasher3_axis"; angle0 = 3.141592; angle1 = 0;};
			class Flasher4 {type = "rotation"; animPeriod = 0.01; selection = "flasher4"; axis = "flasher4_axis"; angle0 = 3.141592; angle1 = 0;};
			class Siren_switcher {type = "rotation"; animPeriod = 0.1; selection = "siren_switcher"; axis = "switchers_axis"; angle0 = 0; angle1 = 3.141592;};
			class Lights_breaking {type = "rotation"; animPeriod = 0.01; selection = "lights_breaking"; axis = "lights_breaking_axis"; angle0 = 0; angle1 = 3.141592;};
			};
		};

	class RAF_33113_01_white: RAF_2203_01_blue
		{
		model = "\RAF-2203\Models\RAF_33113_01.p3d";
		hiddenSelections[] = {"nothing","wheel_covers","wheel_onlays","nothing","nothing","nothing","extra","nothing","nothing","nothing","nothing","nothing","nothing","nothing","nothing","nothing","nothing","nothing","nothing","nothing","nothing","nothing","nothing","awning"};
		displayName = "$STR_RAF_33113_01_white";
		icon = "\RAF-2203\Textures\Icons\RAF_33113_01.paa";
		picture = "\RAF-2203\Textures\Pictures\RAF_33113_01_white.paa";
		weapons[] = {"RAF_2203_klaxon","RAF_2203_wheel_onlays"};
		transportSoldier = 5;
		cargoAction[] = {ManActSkodaCoDriverBack, ManActBusCargo};
		maxSpeed = 95;

		class Animations
			{
			class Dynamic_suspension {type = "rotation"; animperiod = 0.5; selection = "dynamic_suspension"; axis = "dynamic_suspension_axis"; angle0 = -0.1; angle1 = 0.1;};
			class Tilts {type = "rotation"; animperiod = 5; selection = "tilts"; axis = "tilts_axis"; angle0 = 1; angle1 = -1;};
			class Fuel_gauge {type = "rotation"; animPeriod = 1; selection = "fuel_gauge"; axis = "fuel_gauge_axis"; angle0 = 0; angle1 = -1.15;};
			class Inside_sounds_switcher {type = "rotation"; animPeriod = 0.01; selection = "inside_sounds_switcher"; axis = "switchers_axis"; angle0 = 0; angle1 = 3.141592;};
			class Turn_lights_switcher {type = "rotation"; animPeriod = 0.25; selection = "turn_lights_switcher"; axis = "turn_lights_switcher_axis"; angle0 = -0.5; angle1 = 0.5;};
			class Emergency_lights_switcher {type = "rotation"; animPeriod = 0.1; selection = "emergency_lights_switcher"; axis = "emergency_lights_switcher_axis"; angle0 = 0; angle1 = -0.003;};
			class Front_left_turn_light {type = "rotation"; animPeriod = 0.01; selection = "front_left_turn_light"; axis = "front_lights_axis"; angle0 = 3.141592; angle1 = 0;};
			class Front_right_turn_light {type = "rotation"; animPeriod = 0.01; selection = "front_right_turn_light"; axis = "front_lights_axis"; angle0 = 3.141592; angle1 = 0;};
			class Side_left_turn_light {type = "rotation"; animPeriod = 0.01; selection = "side_left_turn_light"; axis = "side_left_turn_light_axis"; angle0 = -3.141592; angle1 = 0;};
			class Side_right_turn_light {type = "rotation"; animPeriod = 0.01; selection = "side_right_turn_light"; axis = "side_right_turn_light_axis"; angle0 = 3.141592; angle1 = 0;};
			class Back_left_turn_light {type = "rotation"; animPeriod = 0.01; selection = "back_left_turn_light"; axis = "back_lights_axis"; angle0 = 3.141592; angle1 = 0;};
			class Back_right_turn_light {type = "rotation"; animPeriod = 0.01; selection = "back_right_turn_light"; axis = "back_lights_axis"; angle0 = 3.141592; angle1 = 0;};
			class Turn_lights_indicator {type = "rotation"; animPeriod = 0.01; selection = "turn_lights_indicator"; axis = "turn_lights_indicator_axis"; angle0 = 3.141592; angle1 = 0;};
			class Emergency_lights_indicator {type = "rotation"; animPeriod = 0.01; selection = "emergency_lights_indicator"; axis = "emergency_lights_indicator_axis"; angle0 = -3.141592; angle1 = 0;};
			class Wipers_switcher {type = "rotation"; animPeriod = 0.15; selection = "wipers_switcher"; axis = "wipers_switcher_axis"; angle0 = 0; angle1 = 0.5;};
			class Wiper1 {type = "rotation"; animPeriod = 1.5; selection = "wiper1"; axis = "wiper1_axis"; angle0 = 0; angle1 = -1.7;};
		  	class Wiper2 {type = "rotation"; animPeriod = 1.5; selection = "wiper2"; axis = "wiper2_axis"; angle0 = 0; angle1 = -1.8;};
			class Handbreak_switcher {type = "rotation"; animPeriod = 0.3; selection = "handbreak_switcher"; axis = "handbreak_switcher_axis"; angle0 = 0; angle1 = 0.7;};
			class Handbreak_indicator {type = "rotation"; animPeriod = 0.01; selection = "handbreak_indicator"; axis = "handbreak_indicator_axis"; angle0 = 3.141592; angle1 = 0;};
			class Reversing_lights {type = "rotation"; animPeriod = 0.01; selection = "reversing_lights"; axis = "back_lights_axis"; angle0 = 3.141592; angle1 = 0;};
			class Lights_breaking {type = "rotation"; animPeriod = 0.01; selection = "lights_breaking"; axis = "lights_breaking_axis"; angle0 = 0; angle1 = 3.141592;};
			};
		};

	class Static: All {};
	class Building: Static {};
	class NonStrategic: Building {};
	class House: NonStrategic {};
	class ViewTower: House {};

	class RAF_2203_militia_lab_ladder: ViewTower
		{
		displayName = "$STR_DN_CAR";
		model = "\RAF-2203\Models\RAF_2203_militia_lab_ladder.p3d";
		nameSound = "car";
		};
};

//========================================= Shadow, 2015 =========================================\\