//===========================================================================================\\

//    -697 ""   "Operation Flashpoint"
//  1.1

//====================================== Shadow, 2015 =======================================\\



class CfgPatches
{
	class LAZ {units[] = {"LAZ_697R"}; weapons[] = {}; requiredVersion = 1.91;};
};



class CfgModels
{
 	class Default {};
	class Vehicle: Default {};
	class Car: Vehicle {};

 	class LAZ_697R: Car {sectionsInherit = "Car"; sections[] = {"color","brzdove svetlo","zadni svetlo","L svetlo","P svetlo","clan","clan_sign"};};
};




class CfgTextureToMaterial
{
	class LAZ_general {textures[] = {"LAZ\Textures\WB.paa","LAZ\Textures\WG.paa","LAZ\Textures\WR.paa","LAZ\Textures\Top.paa","LAZ\Textures\Emblem.paa","LAZ\Textures\Ext.paa","LAZ\Textures\Ext2.paa","LAZ\Textures\Headlamp.paa","LAZ\Textures\Plastic.paa","LAZ\Textures\Rudder.paa","LAZ\Textures\Seat.paa","LAZ\Textures\Wipers.paa","LAZ\Textures\Wood.paa"}; material = #LAZ_general;};
	class LAZ_chrome {textures[] = {"LAZ\Textures\Cover.paa","LAZ\Textures\Fog_lamp.paa","LAZ\Textures\Grille.paa","LAZ\Textures\Metal.paa","LAZ\Textures\Mirror.paa","LAZ\Textures\Turist.paa"}; material = #LAZ_chrome;};
};



class CfgMaterials
{
	class LAZ_general {ambient[] = {1,1,1,1}; diffuse[] = {1,1,1,1}; forcedDiffuse[] = {0,0,0,0}; specular[] = {0.15,0.15,0.15,1}; specularPower = 50; emmisive[] = {0,0,0,0};};
	class LAZ_chrome {ambient[] = {1,1,1,1}; diffuse[] = {1,1,1,1}; forcedDiffuse[] = {0,0,0,0}; specular[] = {0.4,0.4,0.4,1}; specularPower = 50; emmisive[] = {0,0,0,0};};
};



class CfgSounds
{
	class LAZ_door_opening {sound[] = {"\LAZ\Sounds\Door_opening.ogg",0.1,1.0}; name = "LAZ_door_opening"; titles[] = {};};
	class LAZ_door_closing {sound[] = {"\LAZ\Sounds\Door_closing.ogg",0.1,1.0}; name = "LAZ_door_closing"; titles[] = {};};
	class LAZ_motor_start {sound[] = {"\LAZ\Sounds\Motor_start.ogg",0.2,1.0}; name = "LAZ_motor_start"; titles[] = {};};
	class LAZ_motor_start_failure {sound[] = {"\LAZ\Sounds\Motor_start_failure.ogg",0.2,1.0}; name = "LAZ_motor_start_failure"; titles[] = {};};
	class LAZ_motor_off {sound[] = {"\LAZ\Sounds\Motor_off.ogg",0.2,1.0}; name = "LAZ_motor_off"; titles[] = {};};
};



class CfgWeapons
{
	class Default {};
	class CarHorn: Default {};

	class LAZ_klaxon: Carhorn {drySound[] = {"\LAZ\Sounds\Klaxon.ogg",0.1,1.0};};
};



class CfgVehicles
{
	class All {};
	class AllVehicles: All {};
	class Land: AllVehicles {};
	class LandVehicle: Land {};
	class Car: LandVehicle {};
	class Truck: Car {};
	class TruckV3SG: Truck{};
	class TruckV3SCivil: TruckV3SG {};
	class Bus: TruckV3SCivil {};

	class LAZ_697R_white_red: Bus
		{
		model = "\LAZ\Models\LAZ_697R.p3d";
		hiddenSelections[] = {"color"};
		vehicleClass = "$STR_Buses_of_USSR";
		displayName = "$STR_LAZ_697R_white_red";
		icon = "\LAZ\Textures\Icons\LAZ_697R.paa";
		picture = "\LAZ\Textures\Pictures\LAZ_697R_white_red.paa";
		mapSize = 12.5;
		nameSound = "Car";
		crew = "Civilian5";
		getInAction = "ManActGetInCar";
		getOutAction = "ManActGetOutCar";
		driverAction = "ManActBusDriver";
		cargoAction[] = {"ManActSkodaCoDriverBack","ManActSkodaCoDriverBack","ManActSkodaCoDriverBack","ManActSkodaCoDriverBack","ManActSkodaCoDriverBack","ManActSkodaCoDriverBack","ManActSkodaCoDriverBack","ManActSkodaCoDriverBack","ManActSkodaCoDriverBack","ManActSkodaCoDriverBack","ManActSkodaCoDriverBack","ManActSkodaCoDriverBack","ManActSkodaCoDriverBack","ManActSkodaCoDriverBack","ManActSkodaCoDriverBack","ManActSkodaCoDriverBack","ManActSkodaCoDriverBack","ManActSkodaCoDriverBack","ManActSkodaCoDriverBack","ManActSkodaCoDriverBack","ManActSkodaCoDriverBack","ManActSkodaCoDriverBack","ManActSkodaCoDriverBack","ManActSkodaCoDriverBack","ManActSkodaCoDriverBack","ManActSkodaCoDriverBack","ManActSkodaCoDriverBack","ManActSkodaCoDriverBack","ManActBusCargo","ManActSkodaCoDriverBack","ManActSkodaCoDriverBack","ManActSkodaCoDriverBack","ManActBusCargo"};
		transportSoldier = 33;
		castDriverShadow = true;
  		castCargoShadow = true;
		hideWeaponsDriver = true;
		hideWeaponsCargo = true;
		getInRadius = 1;
		maxSpeed = 60;
		turnCoef = 9;
		terrainCoef = 12;
		damperSize = 0.3;
		damperForce = 30;
		brakeDistance = 0.001;
		fuelCapacity = 300;
		transportMaxMagazines = 500;
		transportMaxWeapons = 100;
		soundEngine[] = {"\LAZ\Sounds\Motor.ogg",0.1,1.1};
		soundEnviron[] = {\LAZ\Sounds\Creak.wav,0.1,1.0};
		soundGear[] = {"\LAZ\Sounds\Gear_change.wav",0.005,1.0};
		insideSoundCoef = 0.1;
		weapons[] = {"LAZ_klaxon"};
		accuracy = 0.5;
		armorLights = 0.03;
		armorGlass = 0.05;
		armorWheels = 0.03;
		wheelCircumference = 3.5;
		extCameraPosition[] = {0,1,-15};

		class IndicatorSpeed {selection = "ukaz_rychlo"; axis = "osa_rychlo"; angle = 258; min = 0; max = 35;};
  		class IndicatorRPM {selection = "ukaz_rpm"; axis = "osa_rpm"; angle = 150; min = 0; max = 1.25;};

		class Reflectors
 			{
   			class Left {color[] = {1.0,0.9,0.6,0.35}; ambient[]={1.0,0.9,0.6,0.35}; position = "L svetlo"; direction = "konec L svetla"; hitpoint = "L svetlo"; selection = "L svetlo"; size = 0.5; brightness = 0.25;};
   			class Right {color[] = {1.0,0.9,0.6,0.35}; ambient[]={1.0,0.9,0.6,0.35}; position = "P svetlo"; direction = "konec P svetla"; hitpoint = "P svetlo"; selection = "P svetlo"; size = 0.5; brightness = 0.25;};
			};
			
		class Animations
			{
			class Dynamic_suspension {type = "rotation"; animperiod = 0.5; selection = "dynamic_suspension"; axis = "dynamic_suspension_axis"; angle0 = -0.1; angle1 = 0.1;};
			class Tilts {type = "rotation"; animperiod = 5; selection = "tilts"; axis = "tilts_axis"; angle0 = 1; angle1 = -1;};
			class Drivers_door {type = "rotation"; animperiod = 0.5; selection = "drivers_door"; axis = "drivers_door_axis"; angle0 = 0; angle1 = -1.4;};
			class Passenger_door {type = "rotation"; animperiod = 0.5; selection = "passenger_door"; axis = "passenger_door_axis"; angle0 = 0; angle1 = -1.4;};
			};
		
		class EventHandlers
			{
			Init = "[_this select 0] exec ""\LAZ\Scripts\Init.sqs"" ";
			Engine = "[_this select 0] exec ""\LAZ\Scripts\Engine.sqs"" ";
			GetIn = "if ((_this select 1) == ""driver"") then {[_this select 0,1] exec ""\LAZ\Scripts\Doors.sqs""} else {[_this select 0,0] exec ""\LAZ\Scripts\Doors.sqs""}";
			GetOut = "if ((_this select 1) == ""driver"") then {[_this select 0,1] exec ""\LAZ\Scripts\Doors.sqs""} else {[_this select 0,0] exec ""\LAZ\Scripts\Doors.sqs""}";
			};
		};

	class LAZ_697R_white_blue: LAZ_697R_white_red
		{
		displayName = "$STR_LAZ_697R_white_blue";
		picture = "\LAZ\Textures\Pictures\LAZ_697R_white_blue.paa";
		};
		
	class LAZ_697R_white_green: LAZ_697R_white_red
		{
		displayName = "$STR_LAZ_697R_white_green";
		picture = "\LAZ\Textures\Pictures\LAZ_697R_white_green.paa";
		};
};

//========================================= Shadow, 2015 =========================================\\